/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.crusher.ContainerCrusher;
import com.lothrazar.cyclic.block.crusher.ScreenCrusher;
import com.lothrazar.cyclic.block.generatorfluid.ScreenGeneratorFluid;
import com.lothrazar.cyclic.block.generatoritem.ContainerGeneratorDrops;
import com.lothrazar.cyclic.block.generatoritem.ScreenGeneratorDrops;
import com.lothrazar.cyclic.block.melter.ContainerMelter;
import com.lothrazar.cyclic.block.melter.ScreenMelter;
import com.lothrazar.cyclic.block.packager.ContainerPackager;
import com.lothrazar.cyclic.block.packager.ScreenPackager;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.ScreenSolidifier;
import com.lothrazar.cyclic.block.workbench.ContainerWorkbench;
import com.lothrazar.cyclic.compat.jei.CrusherRecipeCategory;
import com.lothrazar.cyclic.compat.jei.GenfluidRecipeCategory;
import com.lothrazar.cyclic.compat.jei.GenitemRecipeCategory;
import com.lothrazar.cyclic.compat.jei.MelterRecipeCategory;
import com.lothrazar.cyclic.compat.jei.PackagerRecipeCategory;
import com.lothrazar.cyclic.compat.jei.SolidifierRecipeCategory;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainer;
import com.lothrazar.cyclic.item.crafting.simple.CraftingStickContainer;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import com.lothrazar.cyclic.registry.ItemRegistry;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class CyclicPluginJEI
implements IModPlugin {
    private static final int PLAYER_INV_SIZE = 36;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "jei");

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolidifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GenitemRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GenfluidRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PackagerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrusherRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.PACKAGER.get()), new RecipeType[]{PackagerRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.CRAFTER.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.CRAFTING_BAG.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.CRAFTING_STICK.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.WORKBENCH.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.MELTER.get()), new RecipeType[]{MelterRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SOLIDIFIER.get()), new RecipeType[]{SolidifierRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.GENERATOR_ITEM.get()), new RecipeType[]{GenitemRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.GENERATOR_FLUID.get()), new RecipeType[]{GenfluidRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.CRUSHER.get()), new RecipeType[]{CrusherRecipeCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        RecipeManager rm = world.m_7465_();
        registry.addRecipes(RecipeTypes.CRAFTING, rm.m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44107_));
        registry.addRecipes(MelterRecipeCategory.TYPE, List.copyOf(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)CyclicRecipeType.MELTER.get())));
        registry.addRecipes(SolidifierRecipeCategory.TYPE, List.copyOf(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)CyclicRecipeType.SOLID.get())));
        registry.addRecipes(GenitemRecipeCategory.TYPE, List.copyOf(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)CyclicRecipeType.GENERATOR_ITEM.get())));
        registry.addRecipes(GenfluidRecipeCategory.TYPE, List.copyOf(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)CyclicRecipeType.GENERATOR_FLUID.get())));
        registry.addRecipes(CrusherRecipeCategory.TYPE, List.copyOf(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)CyclicRecipeType.CRUSHER.get())));
        registry.addRecipes(PackagerRecipeCategory.TYPE, List.copyOf(rm.m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44107_)));
        for (RegistryObject item : ItemRegistry.ITEMS.getEntries()) {
            ItemStack st = new ItemStack((ItemLike)item.get());
            if (st.m_41619_() || st.m_41720_() instanceof BucketItem) continue;
            registry.addIngredientInfo((Object)st, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent(((Item)item.get()).m_5524_() + ".guide")});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenMelter.class, 75, 20, 40, 26, new RecipeType[]{MelterRecipeCategory.TYPE});
        registry.addRecipeClickArea(ScreenSolidifier.class, 75, 20, 40, 26, new RecipeType[]{SolidifierRecipeCategory.TYPE});
        registry.addRecipeClickArea(ScreenGeneratorDrops.class, 10, 10, 40, 66, new RecipeType[]{GenitemRecipeCategory.TYPE});
        registry.addRecipeClickArea(ScreenGeneratorFluid.class, 50, 8, 20, 20, new RecipeType[]{GenfluidRecipeCategory.TYPE});
        registry.addRecipeClickArea(ScreenPackager.class, 60, 0, 60, 30, new RecipeType[]{PackagerRecipeCategory.TYPE});
        registry.addRecipeClickArea(ScreenCrusher.class, 50, 0, 40, 30, new RecipeType[]{CrusherRecipeCategory.TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerMelter.class, MelterRecipeCategory.TYPE, 0, 2, 2, 36);
        registry.addRecipeTransferHandler(ContainerSolidifier.class, SolidifierRecipeCategory.TYPE, 0, 3, 4, 36);
        registry.addRecipeTransferHandler(CraftingBagContainer.class, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(CraftingStickContainer.class, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerWorkbench.class, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerGeneratorDrops.class, GenitemRecipeCategory.TYPE, 0, 1, 1, 36);
        registry.addRecipeTransferHandler(ContainerCrusher.class, CrusherRecipeCategory.TYPE, 0, 1, 1, 36);
        registry.addRecipeTransferHandler(ContainerPackager.class, PackagerRecipeCategory.TYPE, 0, 1, 1, 36);
    }
}

